﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml.XPath;
using System.IO;
using System.Xml;
using RevisionAnalyser.Projects;
using RevisionAnalyser.Controls;

namespace RevisionAnalyser.Global
{
    public class CurrentProject
    {
        private static CurrentProject _instance;
        public static CurrentProject Instance
        {
            get
            {
                if (_instance == null)
                {
                    _instance = new CurrentProject();
                }
                return _instance;
            }
        }

        private Project _project;
        public Project Project
        {
            get
            {
                return _project;
            }
            set
            {
                _project = value;
            }
        }        

        private CurrentProject()
        {
        }

        public void Open(MainForm mainForm, string file)
        {
            XmlDocument xmlDoc = new XmlDocument();
            xmlDoc.Load(file);
            string projectTypeValue = xmlDoc.SelectSingleNode("./RAProject/GlobalSettings/ProjectType").InnerText;
            ProjectType projectType = ProjectTypes.Instance.GetProjectType(projectTypeValue);
            if (projectType != null)
            {
                Project = projectType.GetProjectInstance();
                Project.ProjectFile = file;
                Project.ProjectFolder = Path.GetDirectoryName(file);
                Project.RevisionSet = mainForm.GetRevisionSet();
                Project.XmlDoc.Load(file);
                Project.MainForm = mainForm;
            }
            else
            {
                throw new Exception("Not a valid project type declared.");
            }
        }

        public void Close()
        {
            if (Project != null)
            {
                Project.XmlDoc.Save(Project.ProjectFile);
                Project = null;
            }
        }
    }
}
